/*
 * img_proc.c
 * Tommaso Polonelli
 *
 * Copyright (C) 2016 ETH Zurich, University of Bologna
 * Copyright (C) 2018 Tommaso Polonelli
 *
 * This software may be modified and distributed under the terms
 * of the MIT license.  See the LICENSE file for details.
 *
 * Created on: June 23, 2020
 *
 */

#include <pmsis.h>
#include "gaplib/jpeg_encoder.h"
#include <bsp/fs.h>
#include <bsp/flash/hyperflash.h>
#include <bsp/fs/hostfs.h>

#include "../Uart_Debug.h"

#include "equalize_hist.h"
#include "gmm.h"
#include "morph.h"
#include "ImgIO.h"

/*********** Constants  ****************/

/* debug */
#define PRINT_IMG	(0)


/* movement threshold
 * the number of 1 pixels for which GAP8
 * must send the full img
 */
#define ONES_TH(x) 	((x>100)&&(x<10000))



/* Defines */
#ifndef FRAME411_HEIGHT
#define FRAME411_HEIGHT 244
#endif
#ifndef FRAME411_WIDTH
#define FRAME411_WIDTH 324
#endif

#define MAKEBN()	do{for (int t = 0; t < (w*h);t++){if (img[t]){img[t] = 255;}else{img[t] = 0;}}}while(0)


/*********** Structures *************/

/*********** Declarations *************/

/*------ Global variables  -----------*/

static RT_L2_DATA struct pi_device ram;
static RT_L2_DATA struct pi_hyperram_conf conf;

#if PRINT_IMG
static struct pi_hostfs_conf conffs;
#endif

/*------ Function prototypes ---------*/


/*********** Functions   ****************/





void MX_IMG_Init(void){

	/* Init & open ram. */
	pi_hyperram_conf_init(&conf);
	pi_open_from_conf(&ram, &conf);
	if (pi_ram_open(&ram))
	{
		printf("Error ram open !\r\n");
		pmsis_exit(-3);
	}
	//GMM
	//InitModel(2, FRAME411_WIDTH, FRAME411_HEIGHT, 2, &ram);

	printf("Img process is configured \r\n");

}


uint8_t MX_IMG_Run (uint8_t *img, int h, int w){

	m_kernel_t KK;
	uint32_t hyper_p;
	uint8_t ret = 0;

#if PRINT_IMG
	//pi_hostfs_conf_init(&conffs);
#endif

	DEBUG_STR("1\n\r");
	// copy to L3 the original IMG
	// Init hyper
	if (pi_ram_alloc(&ram, &hyper_p, (uint32_t) h*w))
	{
		DEBUG_STR("Ram malloc failed !\n\r");
		pmsis_exit(-4);
	}
	else
	{
		DEBUG_STR("Ram allocated : %lx %ld.\n\r", hyper_p, (uint32_t) h*w);
	}
	DEBUG_STR("2\n\r");
	DEBUG_STR("Ram: %x\n\r",ram);
	DEBUG_STR("p: %x\n\r",hyper_p);
	DEBUG_STR("i: %x\n\r",img);
	DEBUG_STR("S: %d\n\r",h*w);
	pi_ram_write(&ram, hyper_p, (uint8_t *)img, (uint32_t) h*w);

#if PRINT_IMG
	//WriteImageToFile("out.pgm", FRAME411_WIDTH, FRAME411_HEIGHT, img);
#endif

	// Remove light differences between frames
	//equalizeHist(img, img, w, h, 0);

#if PRINT_IMG
	//WriteImageToFile("hist.pgm", FRAME411_WIDTH, FRAME411_HEIGHT, img);
#endif

	// GMM run
	printf("3\n\r");
	//BGSubtract(img);
	printf("4\n\r");

	//Morph
	//KK = ConfigDefaultKernel(K_STAR_3);
	// Two close iterations
	//Closing(img, h, w, KK );
	//Closing(img, h, w, KK );
	// One open iteration
	//Opening(img, h, w, KK );
	//Morph
	//ClearDefaultKernel(KK);

	/* Ones counting */
	int errors = Img_Ones_Count (img, FRAME411_WIDTH*FRAME411_HEIGHT);
	DEBUG_STR("Ones: %d \n\r",errors);


	if (ONES_TH(errors)){

#if PRINT_IMG
		MAKEBN();
		//PrintImg(img, "out.raw");
		WriteImageToFile("BG.pgm", FRAME411_WIDTH, FRAME411_HEIGHT, img);
#endif

		ret = 1;
		// copy back
		pi_ram_read(&ram, hyper_p, img, (uint32_t) h*w);
	}

	// free L3 buffer
	pi_ram_free(&ram, hyper_p, (uint32_t) h*w);

	return ret;

}
